//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

namespace Microsoft.Practices.EnterpriseLibrary.Configuration
{
	/// <summary>
	/// Represents a source for getting configuration.
	/// </summary>
	public interface IConfigurationSource
	{
		/// <summary>
		/// When implemented by a class, retrieves a specified configuration section for the for the current application's default configuration.
		/// </summary>
		/// <param name="sectionName">The section name to retrieve.</param>
		/// <returns>The configuration for the section.</returns>
		object GetSection(string sectionName);		
	}
}
